﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;

public partial class DlaRodzica : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!User.Identity.IsAuthenticated)
            Response.Redirect("Default.aspx");
        Label1.Text = User.Identity.Name;
    }
    protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        TableCell cell = e.Row.Cells[0];
        if (cell.Text == "1")
            cell.ForeColor = System.Drawing.Color.Red;
    }
    protected void GridView1_DataBound(object sender, EventArgs e)
    {
        OdswierzSrednia();
    }
    private void OdswierzSrednia()
    {
        DataView data = new DataView();
        data = (DataView)SqlDataSource2.Select(new DataSourceSelectArguments());
        if (data != null && data.Table.Rows.Count > 0)
        {
            double suma = 0;
            double suma2 = 0;
            double srednia = 0;
            for (int i = 0; i < data.Table.Rows.Count; i++)
            {
                suma += double.Parse(data.Table.Rows[i][0].ToString()) *
                    double.Parse(data.Table.Rows[i][1].ToString());
                suma2 += double.Parse(data.Table.Rows[i][1].ToString());
            }
            srednia = Math.Round(suma / suma2, 2, MidpointRounding.ToEven);
            Label2.Text = " " + srednia;
            if (srednia <= 1.49)
            {
                Label3.ForeColor = System.Drawing.Color.Red;
                Label3.Text = " Niedostateczny";
            }
            else
                if ((srednia >= 1.5) && (srednia <= 2.59))
                {
                    Label3.ForeColor = System.Drawing.Color.Black;
                    Label3.Text = " Dopuszczający";
                }
                else
                    if ((srednia >= 2.6) && (srednia <= 3.59))
                    {
                        Label3.ForeColor = System.Drawing.Color.Black;
                        Label3.Text = " Dostateczny";
                    }
                    else
                        if ((srednia >= 3.6) && (srednia <= 4.59))
                        {
                            Label3.ForeColor = System.Drawing.Color.Black;
                            Label3.Text = " Dobry";
                        }
                        else
                            if ((srednia >= 4.6) && (srednia <= 5.59))
                            {
                                Label3.ForeColor = System.Drawing.Color.Black;
                                Label3.Text = " Bardzo dobry";
                            }
                            else
                            {
                                Label3.ForeColor = System.Drawing.Color.Black;
                                Label3.Text = " Celujący";
                            }
        }
        else
        {
            Label2.Text = "";
            Label3.Text = "";
        }
    }
}
